/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.genlayers;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.function.Function;
import java.util.function.IntFunction;
import javax.imageio.ImageIO;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.types.RockCategory;
import net.dries007.tfc.world.classic.biomes.BiomeTFC;
import net.dries007.tfc.world.classic.biomes.BiomesTFC;
import net.dries007.tfc.world.classic.genlayers.GenLayerFuzzyZoomTFC;
import net.dries007.tfc.world.classic.genlayers.GenLayerSmoothTFC;
import net.dries007.tfc.world.classic.genlayers.GenLayerVoronoiZoomTFC;
import net.dries007.tfc.world.classic.genlayers.GenLayerZoomTFC;
import net.dries007.tfc.world.classic.genlayers.biome.GenLayerAddIslandTFC;
import net.dries007.tfc.world.classic.genlayers.biome.GenLayerBiomeEdge;
import net.dries007.tfc.world.classic.genlayers.biome.GenLayerBiomeTFC;
import net.dries007.tfc.world.classic.genlayers.biome.GenLayerDeepOcean;
import net.dries007.tfc.world.classic.genlayers.biome.GenLayerIslandTFC;
import net.dries007.tfc.world.classic.genlayers.biome.GenLayerLakes;
import net.dries007.tfc.world.classic.genlayers.biome.GenLayerShoreTFC;
import net.dries007.tfc.world.classic.genlayers.datalayers.rock.GenLayerRockInit;
import net.dries007.tfc.world.classic.genlayers.datalayers.stability.GenLayerStabilityInit;
import net.dries007.tfc.world.classic.genlayers.river.GenLayerRiverInitTFC;
import net.dries007.tfc.world.classic.genlayers.river.GenLayerRiverMixTFC;
import net.dries007.tfc.world.classic.genlayers.river.GenLayerRiverTFC;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public abstract class GenLayerTFC
extends GenLayer {
    private static final Color[] COLORS = new Color[]{new Color(16757504), new Color(8404597), new Color(16738304), new Color(10927575), new Color(12648480), new Color(13541986), new Color(8482918), new Color(32052), new Color(16152206), new Color(21386), new Color(16743004), new Color(5453690), new Color(16748032), new Color(11741265), new Color(16041984), new Color(8329229), new Color(9677312), new Color(5845781), new Color(15809043), new Color(2305046)};
    protected final int oceanID = Biome.func_185362_a((Biome)BiomesTFC.OCEAN);
    protected final int plainsID = Biome.func_185362_a((Biome)BiomesTFC.PLAINS);
    protected final int highPlainsID = Biome.func_185362_a((Biome)BiomesTFC.HIGH_PLAINS);
    protected final int deepOceanID = Biome.func_185362_a((Biome)BiomesTFC.DEEP_OCEAN);
    protected final int lakeID = Biome.func_185362_a((Biome)BiomesTFC.LAKE);
    protected final int riverID = Biome.func_185362_a((Biome)BiomesTFC.RIVER);
    protected final int swamplandID = Biome.func_185362_a((Biome)BiomesTFC.SWAMPLAND);
    protected final int highHillsID = Biome.func_185362_a((Biome)BiomesTFC.HIGH_HILLS);
    protected final int highHillsEdgeID = Biome.func_185362_a((Biome)BiomesTFC.HIGH_HILLS_EDGE);
    protected final int beachID = Biome.func_185362_a((Biome)BiomesTFC.BEACH);
    protected final int gravelBeachID = Biome.func_185362_a((Biome)BiomesTFC.GRAVEL_BEACH);
    protected final int mountainsID = Biome.func_185362_a((Biome)BiomesTFC.MOUNTAINS);
    protected final int mountainsEdgeID = Biome.func_185362_a((Biome)BiomesTFC.MOUNTAINS_EDGE);

    public static GenLayerTFC[] initializeBiomes(long seed) {
        GenLayerTFC continent = new GenLayerIslandTFC(1L);
        continent = new GenLayerFuzzyZoomTFC(2000L, continent);
        continent = new GenLayerAddIslandTFC(1L, continent);
        continent = new GenLayerZoomTFC(2001L, continent);
        continent = new GenLayerAddIslandTFC(2L, continent);
        continent = new GenLayerZoomTFC(2002L, continent);
        continent = new GenLayerAddIslandTFC(3L, continent);
        continent = new GenLayerZoomTFC(2003L, continent);
        continent = new GenLayerAddIslandTFC(4L, continent);
        continent = new GenLayerDeepOcean(4L, continent);
        GenLayerTFC.drawImageBiomes(1024, continent, "continent");
        GenLayerTFC biomes = new GenLayerBiomeTFC(200L, continent);
        biomes = new GenLayerLakes(200L, biomes);
        biomes = GenLayerZoomTFC.magnify(1000L, biomes, 2);
        biomes = new GenLayerBiomeEdge(1000L, biomes);
        biomes = new GenLayerZoomTFC(1000L, biomes);
        biomes = new GenLayerAddIslandTFC(3L, biomes);
        biomes = new GenLayerZoomTFC(1001L, biomes);
        biomes = new GenLayerShoreTFC(1000L, biomes);
        biomes = new GenLayerZoomTFC(1002L, biomes);
        biomes = new GenLayerZoomTFC(1003L, biomes);
        biomes = new GenLayerSmoothTFC(1000L, biomes);
        GenLayerTFC.drawImageBiomes(1024, biomes, "biomes");
        GenLayerTFC rivers = GenLayerZoomTFC.magnify(1000L, continent, 2);
        rivers = new GenLayerRiverInitTFC(100L, rivers);
        rivers = GenLayerZoomTFC.magnify(1000L, rivers, 6);
        rivers = new GenLayerRiverTFC(1L, rivers);
        rivers = new GenLayerSmoothTFC(1000L, rivers);
        GenLayerTFC.drawImageBiomes(1024, rivers, "rivers");
        GenLayerRiverMixTFC riverMix = new GenLayerRiverMixTFC(100L, biomes, rivers);
        riverMix.func_75905_a(seed);
        GenLayerTFC.drawImageBiomes(1024, riverMix, "mixed");
        GenLayerTFC zoomed = GenLayerZoomTFC.magnify(1000L, riverMix, 2);
        zoomed = new GenLayerSmoothTFC(1001L, zoomed);
        zoomed.func_75905_a(seed);
        GenLayerTFC.drawImageBiomes(1024, zoomed, "zoomed");
        return new GenLayerTFC[]{riverMix, zoomed};
    }

    public static GenLayerTFC initializeRock(long seed, RockCategory.Layer level, int rockLayerSize) {
        GenLayerTFC layer = new GenLayerRockInit(1L, level);
        layer = new GenLayerFuzzyZoomTFC(2000L, layer);
        layer = new GenLayerZoomTFC(2001L, layer);
        layer = new GenLayerZoomTFC(2002L, layer);
        layer = new GenLayerZoomTFC(2003L, layer);
        layer = new GenLayerSmoothTFC(1000L, layer);
        for (int zoomLevel = 0; zoomLevel < rockLayerSize; ++zoomLevel) {
            layer = new GenLayerZoomTFC(1000 + zoomLevel, layer);
        }
        layer = new GenLayerSmoothTFC(1000L, layer);
        layer = new GenLayerVoronoiZoomTFC(10L, layer);
        layer.func_75905_a(seed);
        GenLayerTFC.drawImage(1024, layer, "rock" + level.name());
        return layer;
    }

    public static GenLayerTFC initializeStability(long seed) {
        GenLayerTFC continent = new GenLayerStabilityInit(1L + seed);
        continent = new GenLayerFuzzyZoomTFC(2000L, continent);
        continent = new GenLayerZoomTFC(2001L, continent);
        continent = new GenLayerZoomTFC(2002L, continent);
        continent = new GenLayerZoomTFC(2003L, continent);
        continent = GenLayerZoomTFC.magnify(1000L, continent, 2);
        continent = new GenLayerSmoothTFC(1000L, continent);
        continent = new GenLayerZoomTFC(1000L, continent);
        continent = new GenLayerZoomTFC(1001L, continent);
        continent = new GenLayerZoomTFC(1002L, continent);
        continent = new GenLayerZoomTFC(1003L, continent);
        continent = new GenLayerSmoothTFC(1000L, continent);
        continent = new GenLayerVoronoiZoomTFC(10L, continent);
        continent.func_75905_a(seed);
        GenLayerTFC.drawImage(1024, continent, "stability");
        return continent;
    }

    public static void drawImageBiomes(int size, GenLayerTFC genlayer, String name) {
        Function<Biome, Color> colorize = x -> x instanceof BiomeTFC ? ((BiomeTFC)x).debugColor : Color.BLACK;
        GenLayerTFC.drawImage(size, genlayer, name, i -> (Color)colorize.apply(Biome.func_185357_a((int)i)));
    }

    public static void drawImage(int size, GenLayerTFC genlayer, String name) {
        GenLayerTFC.drawImage(size, genlayer, name, i -> COLORS[i % COLORS.length]);
    }

    public static void drawImage(int size, GenLayerTFC genlayer, String name, IntFunction<Color> gibColor) {
        if (!ConfigTFC.General.DEBUG.debugWorldGenSafe) {
            return;
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        try {
            int[] ints = genlayer.func_75904_a(-size / 2, -size / 2, size, size);
            BufferedImage outBitmap = new BufferedImage(size, size, 1);
            Graphics2D graphics = (Graphics2D)outBitmap.getGraphics();
            graphics.clearRect(0, 0, size, size);
            for (int x = 0; x < size; ++x) {
                for (int z = 0; z < size; ++z) {
                    int i = ints[x * size + z];
                    if (i == -1 || x == size / 2 || z == size / 2) {
                        graphics.setColor(Color.WHITE);
                    } else {
                        graphics.setColor(gibColor.apply(i));
                    }
                    graphics.drawRect(z, x, 1, 1);
                }
            }
            name = "_" + name + ".png";
            TerraFirmaCraft.getLog().info("Worldgen debug image {}", (Object)name);
            ImageIO.write((RenderedImage)outBitmap, "PNG", new File(name));
        }
        catch (Exception e) {
            TerraFirmaCraft.getLog().catching((Throwable)e);
        }
    }

    public GenLayerTFC(long seed) {
        super(seed);
    }

    public boolean isOceanicBiome(int id) {
        return this.oceanID == id || this.deepOceanID == id;
    }

    public boolean isMountainBiome(int id) {
        return this.mountainsID == id || this.mountainsEdgeID == id;
    }

    public boolean isBeachBiome(int id) {
        return this.beachID == id || this.gravelBeachID == id;
    }
}

